/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.file_server;

import ibm.nways.nhm.file_server.RemoteFileServer;
import ibm.nways.nhm.file_server.RemoteInputHandle;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public class RemoteInputStream
extends InputStream {
    private RemoteInputHandle in;

    public RemoteInputStream(String string) throws IOException, RemoteException, NotBoundException {
        String string2 = "rmi://localhost/RFSI";
        RemoteFileServer remoteFileServer = (RemoteFileServer)Naming.lookup(string2);
        this.in = remoteFileServer.getInStream(string);
    }

    public RemoteInputStream(String string, String string2, int n) throws IOException, RemoteException, NotBoundException {
        String string3 = "rmi://" + string2 + ":" + String.valueOf(n) + "/RFSI";
        RemoteFileServer remoteFileServer = (RemoteFileServer)Naming.lookup(string3);
        this.in = remoteFileServer.getInStream(string);
    }

    public int availabe() throws IOException {
        try {
            return this.in.available();
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public void close() throws IOException {
        try {
            this.in.close();
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public synchronized void mark(int n) {
        try {
            this.in.mark(n);
            return;
        }
        catch (Exception exception) {
            System.err.println("RemoteInputStream::mark: Remote error: " + exception);
            return;
        }
    }

    public boolean markSupported() {
        try {
            return this.in.markSupported();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public int read(byte[] byArray) throws IOException {
        try {
            return this.in.read(byArray);
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            return this.in.read(byArray, n, n2);
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public synchronized void reset() throws IOException {
        try {
            this.in.reset();
            return;
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }

    public long skip(long l) throws IOException {
        try {
            return this.in.skip(l);
        }
        catch (RemoteException remoteException) {
            throw new IOException("Remote error: " + remoteException);
        }
    }
}

